//=============================================================================
// ExtraCritical.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/07/17 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 多段クリティカル機構追加機能_追撃チャンス機構
 * @target MZ
 * @author くろあめ
 *
 * @param PursuitStateID
 * @text 追撃チャンスステートID
 * @desc 追撃チャンス発生時にバトラーに付与するステートIDです。
 * @default 34
 * @type number
 *
 * @param PursuitBaseProb
 * @text 追撃チャンス発生確率
 * @desc 追撃チャンスの発生基礎確率(%)です。「設定値×クリティカル段階」がステート付与確率になります。
 * @default 15
 * @type number
 *
 * @param PursuitSe_Actor
 * @text 追撃チャンス効果音(アクター)
 * @desc 追撃チャンスが発生したときの演奏する効果音です。
 * @default
 * @type struct<SE>
 *
 * @param PursuitSe_Enemy
 * @text 追撃チャンス効果音（エネミー）
 * @desc 追撃チャンスが発生したときの演奏する効果音です。
 * @default
 * @type struct<SE>
 *
 * @param PursuitAnime_Actor
 * @text 追撃チャンスアニメ（アクター）
 * @desc 追撃チャンスが発生したとき再生するアニメのIDです。
 * @default 12
 * @type number
 *
 * @param PursuitAnime_Enemy
 * @text 追撃チャンスアニメ（エネミー）
 * @desc 追撃チャンスが発生したとき再生するアニメのIDです。
 * @default 12
 * @type number
 * 
 * @help
 * 多段クリティカルの発生時に
 * クリティカル段階に応じた確率で
 * 特定のステートを攻撃者に付与する機能を追加します。
 *
 * 付与するステートに行動回数追加などを設定することで
 * クリティカルを起こした次の行動にボーナスを付ける機能です。
 *
 * アクター、エネミー、職業、装備、ステートのメモ欄に
 * <PursuitPlus:XX> と記載すると、攻撃の追撃発生倍率がXX%増加します。
 *
 *
 * このプラグインは、多段クリティカル機構プラグイン
 * 「ExtraCritical.js」に機能追加を行うプラグインです
 * 動作には本体である「ExtraCritical.js」導入が前提となります
 * 必ず「ExtraCritical.js」より下に導入してください。
 * 
 * また、このプラグインの利用には
 * MZ公式のDLCプラグイン「PluginCommonBase.js」が必要です
 * 「PluginCommonBase.js」は、RPGツクールMZのインストールフォルダ配下の
 * 以下のフォルダに格納されています。
 * dlc/BasicResources/plugins/official
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/
/*~struct~SE:
 *
 * @param name
 * @text SEファイル名
 * @desc SEのファイル名です。
 * @require 1
 * @dir audio/se/
 * @type file
 * @default
 *
 * @param volume
 * @text SEボリューム
 * @desc SEのボリュームです。
 * @type number
 * @default 90
 * @min 0
 * @max 100
 *
 * @param pitch
 * @text SEピッチ
 * @desc SEのピッチです。
 * @type number
 * @default 100
 * @min 50
 * @max 150
 *
 * @param pan
 * @text SEバランス
 * @desc SEの左右バランスです。
 * @type number
 * @default 0
 * @min -100
 * @max 100
 */

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

const _Game_Action_applyCritical_excri = Game_Action.prototype.apply;
Game_Action.prototype.apply = function(target) {
    _Game_Action_applyCritical_excri.apply(this, arguments);
    const result = target.result();
    const subjectResult = this.subject().result();
    
    if (result.critical_lv > 0 && result.hpDamage > 0) {
        if(!subjectResult.critical_result) subjectResult.critical_result = [];
        subjectResult.critical_result.push(result.critical_lv);
    }
}

const _Window_BattleLog_endAction_excri = Window_BattleLog.prototype.endAction;
Window_BattleLog.prototype.endAction = function(subject) {

    _Window_BattleLog_endAction_excri.apply(this, arguments);
    
    const subjectResult = subject.result();
    
    if(!subject.isStateAffected(param.PursuitStateID) && subjectResult.critical_result && subjectResult.critical_result.length > 0){
        var allcri = 0;
        var rand = 0;
        allcri = subjectResult.critical_result.reduce(function(sum, element){return sum + element;}, 0);
        allcri = allcri * subject.getPursuitPlus();
        
        rand = Math.random() * 100;
        if((allcri !== null) && (rand < allcri) && !$gameParty.isAllDead() && !$gameTroop.isAllDead()){ // 敵味方いずれかが全滅していた場合、戦闘終了と判断して追撃チャンスを発生させない
            
            if (subject.isActor()) {
            
                if (param.PursuitSe_Actor && param.PursuitSe_Actor.name) {
                    AudioManager.playSe(param.PursuitSe_Actor);
                }
                //if ($gameSystem.isSideView()) {
                    const animationId = param.PursuitAnime_Actor;
                    if (animationId > 0 && $dataAnimations[animationId]) {
                        this.push('showNormalAnimation', [subject], animationId);
                        //this.push('waitForAnimation');
                    }
                //}
            }else if(subject.isEnemy()) {
            
                if (param.PursuitSe_Enemy && param.PursuitSe_Enemy) {
                    AudioManager.playSe(param.PursuitSe_Enemy);
                }
                const animationId = param.PursuitAnime_Enemy;
                if (animationId > 0 && $dataAnimations[animationId]) {
                    this.push('showNormalAnimation', [subject], animationId);
                    //this.push('waitForAnimation');
                }
            
            }
            subject.addState(param.PursuitStateID);
            this.displayAutoAffectedStatus(subject);
        }
    }
    
    subjectResult.critical_result = [];
};

Window_BattleLog.prototype.waitForAnimation = function() {
    this.setWaitMode('animation');
};

const _Game_Battler_onTurnEnd_excri = Game_Battler.prototype.onTurnEnd;
Game_Battler.prototype.onTurnEnd = function() {
    const subjectResult = this.result();
    subjectResult.critical_result = [];
    _Game_Battler_onTurnEnd_excri.apply(this, arguments);
};

/* アクターの加算追撃率取得 */
Game_Actor.prototype.getPursuitPlus = function() {
    
    var lastMagni = 0;
    var getMeta = 0;
    
    var states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.PursuitPlus){
            getMeta = states[i].meta.PursuitPlus;
            if(getMeta > 0) lastMagni += Number(getMeta);
        }
    }
    if (this.actor() && this.actor().meta && this.actor().meta.PursuitPlus) {
        getMeta = this.actor().meta.PursuitPlus;
        if(getMeta > 0) lastMagni += Number(getMeta);
    }
    if (this.currentClass() && this.currentClass().meta && this.currentClass().meta.PursuitPlus)  {
        getMeta = this.currentClass().meta.PursuitPlus;
        if(getMeta > 0) lastMagni += Number(getMeta);
    }
    var equips = this.equips();
    for (let i = 0; i < equips.length; i++) {      
        if (equips[i] && equips[i].meta && equips[i].meta.PursuitPlus){
            getMeta = equips[i].meta.PursuitPlus;
            if(getMeta > 0) lastMagni += Number(getMeta);
        }
    }
    return lastMagni + param.PursuitBaseProb;
};


/* エネミーの加算追撃率取得 */
Game_Enemy.prototype.getPursuitPlus = function() {
    
    var lastMagni = 0;
    var getMeta = 0;
    
    var states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.PursuitPlus){
            getMeta = states[i].meta.PursuitPlus;
            if(getMeta > 0) lastMagni += Number(getMeta);
        }
    }
    if (this.enemy() && this.enemy().meta && this.enemy().meta.PursuitPlus) {
        getMeta = this.enemy().meta.PursuitPlus;
        if(getMeta > 0) lastMagni += Number(getMeta);
    }
    
    return lastMagni + param.PursuitBaseProb;
};

})();